# R script for comparision of CASP1-GFP intensity between sides affected/unaffected by ablation


setwd("F:/Google Drive/PhD/Paper with Peter/nice pictures/Ablation/C1_membraneIntensity/")



# Data loading
library(readr)
library(dplyr)
library(ggplot2)


mydata <- read_csv("whole root/Results.csv")


# Reduce labels to sane levels
roi_labels <- c("ctrl", "background", "ablation")
mydata$Label <- c(rep(roi_labels, nrow(mydata)/length(roi_labels)))

# Apply true time values -> 1 frame each 2.5 h
mydata <- mydata %>%
  mutate(Time = Slice*2.5-2.5)

# filter for ROIs to apply background substraction
ctrl <- mydata %>%
  filter(Label == "ctrl")

ablation <- mydata %>%
  filter(Label == "ablation")

background <- mydata %>%
  filter(Label == "background")


# Background substraction
r_ctrl <- ctrl %>%
  mutate(IntDen_bg = (IntDen - background$IntDen)/max(ctrl$IntDen)) %>%
  select(Label, Time, IntDen_bg)

r_ablation <- ablation %>%
  mutate(IntDen_bg = (IntDen - background$IntDen)/max(ctrl$IntDen)) %>%
  select(Label, Time, IntDen_bg)


#r_background <- background %>%
#  mutate(IntDen_bg = IntDen - background$IntDen) %>%
#  select(Label, Slice, IntDen_bg)

# Recombine ctrl & ablated values into single dataframe for plotting
newdata <- rbind(r_ctrl, r_ablation)


# plots
p1 <- ggplot(data = newdata, aes(x=Time, y=IntDen_bg, group = Label, col = Label))+
  geom_line()+
  geom_point()+
  #geom_smooth()+
  theme_classic()+
  scale_color_manual(values = c("#af232a", "forestgreen"))+
  ylim(0,1)+
  #xlim(0,12)+
  labs(x = "Time [h]", y = "Relative GFP intensity", col = "")+
  theme(legend.position="top")

p1

# Export plot as PDF
pdf("whole root/Ablation_intensity.pdf", useDingbats=FALSE, width = 1.49606, height = 2.55906)
p1
dev.off()


